package com.bitbof.escape.entities;

import java.util.LinkedList;
import java.util.List;

import org.lwjgl.examples.spaceinvaders.Texture;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

import com.bitbof.escape.Art;

public class Blob implements Entity {

	private World world;
	public Vector2f pos, v, a;
	public float deg, vdeg, adeg;
	public float scale, age;
	public boolean alive = true;
	public Blob parent;
	public List<Entity> children, addQueue;
	
	public final float MIN_SCALE = 40;

	public Blob(World world, Blob parent, float x, float y, float scale) {
		this.parent = parent;
		this.world = world;
		pos = new Vector2f(x,y);
		v = new Vector2f(0,0);
		a = new Vector2f(0,0);
		this.scale = scale;
		spawnChildren();
	}

	public Blob(World world, Blob parent) {
		this.parent = parent;
		this.world = world;
		pos = new Vector2f(0,0);
		v = new Vector2f(0,0);
		a = new Vector2f(0,0);
		if (parent != null) {
			scale = parent.scale / 4;
			pos.x = (float) ((Math.random() - 0.5) * scale * scale);
			pos.y = (float) ((Math.random() - 0.5) * scale * scale);
		}
		spawnChildren();
		
	}
	
	private void spawnChildren() {
		children = new LinkedList<Entity>();
		addQueue = new LinkedList<Entity>();
		if (scale >= MIN_SCALE) {
			for (int i = 0; i < 3; i++)
				children.add(new Blob(world, this));
		}
		//if(parent == null)
			//children.add(new Player(world));
	}
	

	public void die() {
		if (!alive)
			return;
		alive = false;
		// init();
		for (Entity e : world.entities) {
			if (e.getClass() != Blob.class)
				continue;
			Blob b = (Blob) e;
			if (b.parent == this)
				b.kill();
		}
		parent.add(new Blob(world, parent));
	}

	public void kill() {
		if (!alive)
			return;
		alive = false;
		// init();
		for (Entity e : children) {
			if (e.getClass() != Blob.class)
				continue;
			Blob b = (Blob) e;
			if (b.parent == this)
				b.kill();
		}
	}

	@Override
	public void tick() {
		if (!alive)
			return;
		if(parent != null) {
			age += 1 / scale * Math.random()*world.timeFactor;
			if (age >= 1) {
				//die();
				// alive = false;
			}
			a.x = (float) (a.x * 0.9 + 0.1 * (float) (Math.random() - 0.5) * world.timeFactor);
			a.y = (float) (a.y * 0.9 + 0.1 * (float) (Math.random() - 0.5) * world.timeFactor);
			adeg = (float) (adeg * 0.9 + 0.1 * (float) (Math.random() - 0.5) * world.timeFactor);
			v.x += a.x;
			v.y += a.y;
			vdeg += adeg;
			pos.x += v.x;
			pos.y += v.y;
			deg += vdeg;
			if (parent != null) {
				float dist = pos.length();
				if (dist > parent.scale / 2f - scale/2f) {
					Vector2f vec = new Vector2f(pos);
					vec.normalise();
					
					vec.x *= parent.scale / 2f - scale/2f;
					vec.y *= parent.scale / 2f - scale/2f;
					pos.x = vec.x;
					pos.y = vec.y;
					a.x = 0;
					a.y = 0;
					//vx = 0;
					//vy = 0;
				}
			}
	
			v.x *= 0.99f;
			v.y *= 0.99f;
			vdeg *= 0.99f;
		} else {
			pos.x = world.camera.pos.x;
			pos.y = world.camera.pos.y;
		}
		children.addAll(addQueue);
		addQueue.clear();
		//take care of children...so cute!
		for(int i = 0; i < children.size(); i++) {
			Entity e = children.get(i);
			e.tick();
			if(!e.isAlive()){
				children.remove(i--);
			}
		}
		{	//collision
			
			//get collisions
			for(int i = 0; i < children.size(); i++) {
				for(int e = 0; e < children.size(); e++) {
					if(children.get(i).getClass() != Blob.class || children.get(e).getClass() != Blob.class) {
						if(children.get(i).getClass() == Blob.class && children.get(e).getClass() == Player.class || children.get(e).getClass() == Blob.class && children.get(i).getClass() == Player.class)
						{
							Blob bA; 
							Player bB;
							
							if(children.get(i).getClass() == Blob.class) {
								bA = (Blob) children.get(i);
								bB = (Player) children.get(e);
							} else {
								bA = (Blob) children.get(e);
								bB = (Player) children.get(i);
							}
							
							float dist = new Vector2f(bA.pos.x-bB.pos.x, bA.pos.y-bB.pos.y).length();
							if(dist < bA.scale/2f+bB.width/2f) {
								
								Vector2f dif = new Vector2f(bA.pos.x-bB.pos.x, bA.pos.y-bB.pos.y);
								dif.normalise();
								float fac = dist - bA.scale/2f-bB.width/2f;
								dif.x *= fac;
								dif.y *= fac;
								bB.pos.x += dif.x/2f;
								bB.pos.y += dif.y/2f;

								bA.pos.x -= dif.x/2f;
								bA.pos.y -= dif.y/2f;
								//bB.v.x = 0;
								//bB.v.y = 0;
								bA.v.x = 0;
								bA.v.y = 0;
							}
						}

						continue;
					}
					
					Blob bA = (Blob) children.get(i);
					Blob bB = (Blob) children.get(e);
					if(bA == bB)
						continue;
					float dist = new Vector2f(bA.pos.x-bB.pos.x, bA.pos.y-bB.pos.y).length();
					if(dist < bA.scale/2f+bB.scale/2f) {
						Vector2f dif = new Vector2f(bA.pos.x-bB.pos.x, bA.pos.y-bB.pos.y);
						dif.normalise();
						float fac = dist - bA.scale/2f-bB.scale/2f;
						dif.x *= fac;
						dif.y *= fac;
						bB.pos.x += dif.x/2f;
						bB.pos.y += dif.y/2f;

						bA.pos.x -= dif.x/2f;
						bA.pos.y -= dif.y/2f;
						bB.v.x = 0;
						bB.v.y = 0;
						bA.v.x = 0;
						bA.v.y = 0;
					}
				}
			}
			
			
			//resolve
			
		}
	}

	@Override
	public void render() {
		if (!alive)
			return;
		if(true){//parent != null) {
				if(scale < MIN_SCALE) {
					Art.ball.bind();
				}
				else {
					Art.blob.bind();
				}
				GL11.glPushMatrix();
				/*Blob p = parent;
				while (p != null) {
					GL11.glTranslatef(p.x, p.y, 0);
					p = p.parent;
				}*/
				GL11.glTranslatef(pos.x, pos.y, 0);
				
				float ageVal = (float) Math.min(1 - Math.pow(4, -age * 15),
						1 - Math.pow(4, age * 15 - 15));
				//if (parent == null)
					ageVal = 1;
				GL11.glColor4f(1,1,1, ageVal*0.05f);
		
				Texture texture = Art.blob;
				// rotate square according to angle
				GL11.glRotatef(deg, 0, 0, 1);
				GL11.glPushMatrix();
				GL11.glScalef(scale, scale, scale);
				
				
				{ //draw quad
					GL11.glBegin(GL11.GL_QUADS);
					GL11.glTexCoord2f(0, 0);
					GL11.glVertex2f(-0.5f, -0.5f);
					GL11.glTexCoord2f(0, texture.getHeight());
					GL11.glVertex2f(0.5f, -0.5f);
					GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
					GL11.glVertex2f(0.5f, 0.5f);
					GL11.glTexCoord2f(texture.getWidth(), 0);
					GL11.glVertex2f(-0.5f, 0.5f);
					GL11.glEnd();
				}
				GL11.glPopMatrix();
				
				for(int i = 0; i < children.size(); i++) {
					Entity e = children.get(i);
					e.render();
				}
				GL11.glPopMatrix();
		}
			
		
		

	}
	
	public void add(Entity e) {
		addQueue.add(e);
	}

	@Override
	public boolean isAlive() {
		return alive;
	}

}
